/* "enchack.c" -- decode .enc and .enx files from a World Library CD-ROM. */

#include <stdio.h>

main(int argc, char **argv) {

    int c;
    FILE *enc;

    if (argc == 1) {
        enc = stdin;
    } else if ( (enc = fopen(argv[1], "r")) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", argv[0], argv[1]);
        exit(1);
    }

    /* Everything but CR/LF is 0x72 off from ASCII. */

    while ((c = fgetc(enc)) != EOF) {
        if (c >= 0x92 && c <= 0xf0) 
            putchar(c - 0x72); 
        else
            putchar(c); 
    }

}
