/* "wlcat.c" -- decode an a World Library CD-ROM ****************************
 *
 * This program decodes the .etx file on a World Library CD-ROM and can be 
 * called as a pipe, with a file name, or with three arguments: file name, 
 * start byte, and end byte (relative to the decoded text).
 *
 * I can't find it, but there must be a file that stores byte offsets
 * relative to the encoded text.  The included DOS/Windows browsers
 * can far too quickly to be decoding everything.
 *
 ****************************************************************************/

#include <stdio.h>
#include <string.h>

main(int argc, char **argv) {

    int c, i, byte_count;
    FILE *etx;

    if (argc == 1) {
        etx = stdin;
    } else if ( (etx = fopen(argv[1], "r")) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", argv[0], argv[1]);
        exit(1);
    }

    if (argc == 4) { 

        /* Seek to byte in decrypted text.  Can't use fseek, because we 
           need to read everything to count decoded bytes. */

        byte_count = atoi(argv[2]);
        while (byte_count-- > 0 && (c=fgetc(etx)) != EOF) {
            if (c < 0x7f) {
                byte_count--;
                if (c==0x1F) {
                    c = fgetc(etx);
                    byte_count -= (c-0x22);
                }
            }
        }

        /* Now, set byte_count to the number of bytes we should show.  
           We will count down until byte_count == 0.  */

        byte_count = atoi(argv[3]) - atoi(argv[2]);

    }

    while ((c = fgetc(etx)) != EOF) {

        if (argc==4 && byte_count<=0) { /* printed enough bytes, so quit */
            exit(0);
        }
    
        if (c==0x1F) {

            /* Run-length encoded spaces.  Next byte is the number of
               spaces plus 0x20.  Ox6C marks a new paragraph, but still 
               counts as 0x4C bytes. */

            c = fgetc(etx);
            byte_count -= (c-0x20);
            for (i=0; i < c-0x20; i++) 
                putchar(' ');

        } else if (c==0xFE) {

            /* First byte of a special code.  If the next byte is...
               0xE2: begin special text (xref & copyright notice)
               0xC2: end special text
               0xF9: begin/end picture reference
                     The text between marks will be "filename.cif", but
                     actually refers to the "filename.pcx" file. */

            byte_count--;
            c = fgetc(etx); 

        } else if (c < 0x7f) {

            /* A space followed by a character is encoded by the
               second character's value. */

            byte_count -= 2;
            putchar(' ');
            putchar(c);

        } else {

            /* When not preceded by a space, a character is encoded by
               adding 0x79 to it. */

            byte_count--;
            putchar(c - 0x79);

        }
    } 

}
